local S = minetest.get_translator(minetest.get_current_modname())
local question_block_functions = {
    function(player)
        minetest.chat_send_all(S("Player @1 has questions!", player:get_player_name()))
    end,
    function(player)
        local reason = S("You are too cool to play on this server!")
        minetest.chat_send_all(S("Player @1 got kicked for reason: @2", player:get_player_name(), reason))
        minetest.kick_player(player:get_player_name(), reason)
    end,
    function(player)
        player:set_breath(1)
    end,
    function(player)
        minetest.chat_send_player(player:get_player_name(), S("You have been rotated!!"))
        player:set_look_pitch(math.random(-180, 180))
        player:set_look_yaw(math.random(-180, 180))
        player:set_look_horizontal(math.random(-180, 180))
        player:set_look_vertical(math.random(-180, 180))
    end,
    function(player)
        local inventory = player:get_inventory()
        -- ItemStack({name = "default:dirt", count = 99})
        while true do
            local amount = inventory:add_item("main", "default:dirt 999"):get_count()
            if amount > 0 then
                break
            end
        end
        return false
    end,
    function(player)
        local inventory = player:get_inventory()
        local stack1 = "default:gold_ingot " .. tostring(math.random(1, 7))
        local stack2 = "default:goldblock " .. tostring(math.random(1, 15))
        inventory:add_item("main", stack1)
        inventory:add_item("main", stack2)
    end,
}

minetest.register_node("usable_nodes:kill_block", {
    description = S("Kill Block"),
    tiles = {"kill_block.png"},
    groups = {oddly_breakable_by_hand = 3},
    after_use = function(pos, player)
        if minetest.settings:get_bool("enable_damage") then
            return player:set_hp(0)
        else
            minetest.chat_send_player(
                player:get_player_name(),
                S("Damage must be enabled in order to kill the player @1", player:get_player_name())
            )
        end
    end
})
minetest.register_node("usable_nodes:move_block", {
    description = S("Move Block"),
    tiles = {"move_block.png"},
    groups = {oddly_breakable_by_hand = 3},
    after_use = function(pos, player)
        local position = player:get_pos()
        return player:move_to({
            x = position.x + 1,
            y = position.y + 1,
            z = position.z + 1})
    end
})
minetest.register_node("usable_nodes:damage_block", {
    description = S("Damage Block"),
    tiles = {"damage_block.png"},
    groups = {oddly_breakable_by_hand = 3},
    after_use = minetest.item_eat(-1)
})
minetest.register_node("usable_nodes:heal_block", {
    description = S("Heal Block"),
    tiles = {"heal_block.png"},
    groups = {oddly_breakable_by_hand = 3},
    after_use = minetest.item_eat(1)
})
minetest.register_node("usable_nodes:eatable_block", {
    description = S("Eatable Block"),
    tiles = {"eatable_block.png"},
    groups = {oddly_breakable_by_hand = 3},
    after_use = minetest.item_eat(math.abs(minetest.PLAYER_MAX_HP_DEFAULT - 2))
})
minetest.register_node("usable_nodes:inedible_block", { -- NEW!
    description = S("Inedible Block"),
    tiles = {"inedible_block.png"},
    groups = {oddly_breakable_by_hand = 3},
    after_use = minetest.item_eat( - (minetest.PLAYER_MAX_HP_DEFAULT - 2))
})
minetest.register_node("usable_nodes:breath_block", {
    description = S("Breath Block"),
    tiles = {"breath_block.png"},
    groups = {oddly_breakable_by_hand = 3},
    after_use = function(pos, player)
        if minetest.settings:get_bool('enable_damage') then
            player:set_breath(player:get_breath() + 1)
        end
    end
})
minetest.register_node("usable_nodes:suffocation_block", {
    description = S("Suffocation Block"),
    tiles = {"suffocation_block.png"},
    groups = {oddly_breakable_by_hand = 3},
    after_use = function(pos, player)
        if minetest.settings:get_bool('enable_damage') then
            player:set_breath(player:get_breath() - 1)
        end
    end
})
minetest.register_node("usable_nodes:question_block", {
    description = S("Question Block"),
    tiles = {"question_block.png"},
    groups = {oddly_breakable_by_hand = 3},
    after_use = function(pos, player)
        return question_block_functions[math.random(#question_block_functions)](player)
    end
})

minetest.register_alias("kill_block", "usable_nodes:kill_block")
minetest.register_alias("move_block", "usable_nodes:move_block")
minetest.register_alias("damage_block", "usable_nodes:damage_block")
minetest.register_alias("heal_block", "usable_nodes:heal_block")
minetest.register_alias("eatable_block", "usable_nodes:eatable_block")
minetest.register_alias("inedible_block", "usable_nodes:inedible_block")
minetest.register_alias("breath_block", "usable_nodes:breath_block")
minetest.register_alias("suffocation_block", "usable_nodes:suffocation_block")
minetest.register_alias("question_block", "usable_nodes:question_block")